# Draw a spectrogram with waveform and textgrid information and
# saves the resulting image in EMF and EPS formants.
#
# Written by Mauricio Figueroa (June, 2014)
#
# This script is free software: you can redistribute it and/or modify 
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# A copy of the GNU General Public License is available at
# <http://www.gnu.org/licenses/>.

# Opening files and erasing draw screen.
id_textgrid = Read from file: "elision.TextGrid"
id_sound = Read from file: "elision.wav"
Erase all

# Drawing the sound wave.
Select inner viewport: 1.0, 5.0, 1.6, 2.2
select id_sound
Line width: 1
Colour: "Black"
Draw: 0.0, 0.0, 0.0, 0.0, "no", "Curve"

# Drawing the spectrogram.
Select inner viewport: 1.0, 5.0, 2.2, 3.5
id_spectrogram = To Spectrogram: 0.005, 5500, 0.002, 20, "Gaussian"
Paint: 0.0, 0.0, 0.0, 0.0, 100.0, "yes", 45.0, 6.0, 0.0, "no"
Marks right: 2, "yes", "yes", "no"

# Drawing the intensity contour and the inner box for the spectrogram.
select id_sound
id_intensity = To Intensity: 100, 0.0, "yes"
Line width: 2
Colour: "Cyan"
Draw: 0.0, 0.0, 30, 65, "no"
Line width: 1
Colour: "Black"
Draw inner box

# Drawing the textgrid on top of all.
Select inner viewport: 1.0, 5.0, 1.6, 4.45
select id_textgrid
Draw: 0.0, 0.0, "yes", "no", "no"
Marks bottom: 2, "yes", "yes", "no"
Draw inner box

# Select the whole thing and save the resulting files.
Select inner viewport: 1.45, 4.75, 1.80, 4.45
Save as Windows metafile: "draw_elision.emf"
Save as EPS file: "draw_elision.eps"
