# Cleaning Praat's Info window.
clearinfo

# Number of random numbers to create.
how_many_random = 100

# Minimal and maximal years to circumscribe the randomization process.
year_zero = 0
year_of_our_Lord = 2014

# Baseline variables that will go down or up if a lower or higher value is found.
baseline_minimum = 0
baseline_maximum = 0

# For loop to create and assess the numbers. By default, it cycles 100 times. Notice that "from 1" has been omitted.
for i to how_many_random
	# Creating a new random number using predefined min. and max.
		new_random = randomInteger(year_zero, year_of_our_Lord)
	# Only for the first cycle of the loop, assign the random number to the baseline variables.
		if i == 1
			baseline_minimum = new_random
			baseline_maximum = new_random
		endif
	# Assess whether the new random number is smaller than the baseline. If it is, save that in baseline.
		if new_random < baseline_minimum
			baseline_minimum = new_random
		endif
	# Assess whether the new random number is larger than the baseline. If it is, save that in baseline.
		if new_random > baseline_maximum
			baseline_maximum = new_random
		endif
	# Uncomment the following line to see the list of results evaluated. Notice the use of "tab$".
		; appendInfoLine: i, tab$, new_random, tab$, baseline_minimum, tab$, baseline_maximum
endfor

# Send results to the screen.
appendInfoLine: "The minimum random year found was: ", baseline_minimum, ". The maximum was: ", baseline_maximum, "."
