# Declaring the form elements:
form Name trimmer
	comment Enter your name and decide how short you want it now:
	word First_name: Horacito (= example)
	integer Characters: 3 (= example)
	boolean Reduplicate 1
endform

# Parsing the inputted name:
length_original_name = length(first_name$)
if characters > length_original_name
	# If the specified characters are longer than the name's characters, terminate script.
	exitScript: "You specified more characters (", string$(characters), ") than the length of your name (", string$(length_original_name), ").", newline$
elsif characters == length_original_name
	# If the specified characters are equal than the name's characters, terminate the script.
	exitScript: "You specified the same number of characters (", string$(characters), ") as your name length (", string$(length_original_name), ").", newline$
else
	# Else, trim the name to become as short as the specified number of characters.
	trimmed_name$ = left$(first_name$, characters)
endif

# Publish results, depending on reduplication decision:
if reduplicate == 1
	# If reduplicated, reduplicate name.
	reduplicated_name$ = trimmed_name$ + trimmed_name$
	writeInfoLine: "Your new name is: ", reduplicated_name$, "."
else
	# If not, publish as it is.
	writeInfoLine: "Your new name is: ", trimmed_name$, "."
endif
