# Clearing Praat Info window.
clearinfo

# Calling the procedure several times.
@dealing_with_strings: "crocodile", 5, "c", "l"
@dealing_with_strings: "hippopotamus", 10, "i", "m"
@dealing_with_strings: "immateriality", 3, "i", "m"

# Defining the procedure.
procedure dealing_with_strings: string_to_parse$, how_short, check_first$, check_last$
	# Parsing the string.
	string_to_evaluate$ = string_to_parse$
	short_string$ = left$(string_to_evaluate$, how_short)
	first_character$ = left$(short_string$, 1)
	last_character$ = right$(short_string$, 1)

	# Assessing first character match.
	if first_character$ == check_first$
		first_character_match$ = "YES"
	else
		first_character_match$ = "NO"
	endif
	
	# Assessing second character match.
	if last_character$ == check_last$
		last_character_match$ = "YES"
	else
		last_character_match$ = "NO"
	endif

	# Reporting to the user.
	appendInfoLine: "The short version of the string ", string_to_evaluate$, " is: ", short_string$, ". First character match: ", first_character_match$, ". Last character match: ", last_character_match$, "."
endproc
