# Script "what's_wrong_with_you_2_SOLUTION_1.praat". Uses brute force
# via string functions to assess the required conditions.

# Cleaning the Praat Info line:
clearinfo

# Definition of variables:
my_number = -0.366
my_string$ = "AgilaoAmpelman"

# Testing "my_number":
	# Extracting information from number:
	round_my_number = round(my_number)
	# Testing if number is integer:
	if my_number <> round_my_number
		exitScript: "Your number must be an integer (number: ", string$(my_number), ").", newline$
	# Testing for negative numbers:
	elsif my_number < 0
		exitScript: "Your number should be positive (number: ", string$(my_number), ").", newline$
	# Testing for numbers not bigger than 18:
	elsif my_number < 19
		exitScript: "Your number must be larger than 18 (number: ", string$(my_number), ").", newline$
	# Testing for numbers not smaller than 120:
	elsif my_number > 119
		exitScript: "Your number must be smaller than 120 (number: ", string$(my_number), ").", newline$
	endif
appendInfoLine: "All tests for the number <", string$(my_number), "> ok."

# Testing "my_string$":
	# Extracting information from string:
		string_length = length(my_string$)
		first_character$ = left$(my_string$, 1)
		last_character$ = right$(my_string$, 1)
	# Creating tools to parse string: 
		lowercase_string$ = "abcdefghijklmnopqrstuvwxyz"
		vowels_string$ = "aeiouAEIOU"
		length_alphabet = length(lowercase_string$)
		length_vowels = length(vowels_string$)
	# Defining checking variables to be changed only in if conditions are met:
		lowercase_check = 0
		vowels_check = 0
	# For loop to assess first character:
		for i from 1 to length_alphabet
			current_character_A$ = mid$(lowercase_string$, i, 1)
			# If condition is met, change checking variable:
				if first_character$ == current_character_A$
					lowercase_check = 1
				endif
		endfor
	# Assess whether checking variable remains the same and act accordingly:
		if lowercase_check == 0
			exitScript: "Your string must start with a lowercase from a-z (string: <", my_string$, ">).", newline$
		endif
	# For loop to assess last character:
		for i from 1 to length_vowels
			current_character_B$ = mid$(vowels_string$, i, 1)
			# If condition is met, change checking variable:
				if last_character$ == current_character_B$
					vowels_check = 1
				endif
		endfor
	# Assess whether checking variable remains the same and act accordingly:
		if vowels_check == 0
			exitScript: "Your string must end with a vowel (string: <", my_string$, ">).", newline$
		endif
	# Assess length of string and act accordingly:
		if string_length > 9
			exitScript: "Your string must be shorter than 10 characters (string <", my_string$, "> is ", string$(string_length), " characters long).", newline$
		endif
appendInfoLine: "All tests for the string <", my_string$, "> ok."
