# Script "what's_wrong_with_you_2_SOLUTION_1.praat". This one uses
# regular expressions (regex) to parse the string.

# Cleaning the Praat Info line:
clearinfo

# Definition of variables:
my_number = -0.366
my_string$ = "AgilaoAmpelman"

# Testing "my_number":
	# Extracting information from number:
	round_my_number = round(my_number)
	# Testing if number is integer:
	if my_number <> round_my_number
		exitScript: "Your number must be an integer (number: ", string$(my_number), ").", newline$
	# Testing for negative numbers:
	elsif my_number < 0
		exitScript: "Your number should be positive (number: ", string$(my_number), ").", newline$
	# Testing for numbers not bigger than 18:
	elsif my_number < 19
		exitScript: "Your number must be larger than 18 (number: ", string$(my_number), ").", newline$
	# Testing for numbers not smaller than 120:
	elsif my_number > 119
		exitScript: "Your number must be smaller than 120 (number: ", string$(my_number), ").", newline$
	endif
appendInfoLine: "All tests for the number <", string$(my_number), "> ok."

# Testing "my_string$":
	# Extracting information from string:
		string_length = length(my_string$)
	# Using regex to find the first occurrence of a lowercase character:
		where_first_lowercase = index_regex(my_string$, "[a-z]")
	# If the first occurrence is not the first character (1), terminate the script:
		if where_first_lowercase <> 1
			exitScript: "Your string must start with a lowercase from a-z (string: <", my_string$, ">).", newline$
		endif
	# Using regex to find the last occurrence of a vowel:
		where_last_vowel = rindex_regex(my_string$, "[aeiouAEIOU]")
	# If the last occurrence is not the last character (= length), terminate the script:
		if where_last_vowel <> string_length
			exitScript: "Your string must end with a vowel (string: <", my_string$, ">).", newline$
		endif
	# Assess length of string and act accordingly:
		if string_length > 9
			exitScript: "Your string must be shorter than 10 characters (string <", my_string$, "> is ", string$(string_length), " characters long).", newline$
		endif
appendInfoLine: "All tests for the string <", my_string$, "> ok."
