# select all
# nocheck Remove

synth_id = Create SpeechSynthesizer: "English", "default" 
table_id = Read Table from comma-separated file: "happy_birthday_table.csv"
n_rows   = Get number of rows

for i from 1 to n_rows
  selectObject: table_id
  syllable$ = Get value: i, "syllable"
  frequency = Get value: i, "frequency"
  target_duration  = Get value: i, "duration_s"

  selectObject: synth_id
  syllable_snd_id[i] = To Sound: syllable$, "no"
  real_duration = Get total duration

  duration_factor = (target_duration * 1) / real_duration

  syllable_man_id[i] = To Manipulation: 0.01, 75, 600
  syllable_pch_id[i] = Extract pitch tier
  Remove points between: 0, real_duration
  Add point: 0, frequency
  Add point: real_duration, frequency

  selectObject: syllable_man_id[i], syllable_pch_id[i]
  Replace pitch tier
  # removeObject: syllable_pch_id[i]

  selectObject: syllable_man_id[i]
  syllable_dur_man_id[i] = Extract duration tier
  Add point: 0, duration_factor
  Add point: real_duration, duration_factor
  selectObject: syllable_man_id[i], syllable_dur_man_id[i]
  Replace duration tier
  selectObject: syllable_man_id[i]
  new_syllable[i] = Get resynthesis (overlap-add)

  removeObject: syllable_snd_id[i], syllable_man_id[i], syllable_pch_id[i],
  	... syllable_dur_man_id[i]

endfor

nocheck selectObject: undefined
for i from 1 to n_rows
  plusObject: new_syllable[i]
endfor

final_sound = Concatenate with overlap: 0.01

nocheck selectObject: undefined
for i from 1 to n_rows
  plusObject: new_syllable[i]
endfor
Remove

selectObject: final_sound
